/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2881;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_746;
import net.minecraft.class_9829;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.mixin.common.miscellaneous.IEEndDragonFight;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.NormalAnimation;
import qouteall.imm_ptl.core.portal.animation.RotationAnimation;
import qouteall.imm_ptl.core.portal.shape.BoxPortalShape;
import qouteall.q_misc_util.Helper;

public class EndPortalEntity
extends Portal {
    private static final Logger LOGGER = LogManager.getLogger(EndPortalEntity.class);
    public static final class_1299<EndPortalEntity> ENTITY_TYPE = EndPortalEntity.createPortalEntityType(EndPortalEntity::new);
    public static final String PORTAL_TAG_VIEW_BOX = "view_box";
    private static final double BOX_PORTAL_SIDE_LEN = 3.0;
    private static final double BOX_PORTAL_HEIGHT = 1.5;

    public EndPortalEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.setCrossPortalCollisionEnabled(false);
    }

    public static void onEndPortalComplete(class_3218 world, class_243 portalCenter) {
        class_3218 endDim = world.method_8503().method_3847(class_1937.field_25181);
        if (endDim == null) {
            return;
        }
        IPGlobal.EndPortalMode endPortalMode = IPGlobal.endPortalMode;
        if (endPortalMode == IPGlobal.EndPortalMode.normal) {
            EndPortalEntity.generateClassicalEndPortal(world, new class_243(0.0, 120.0, 0.0), portalCenter);
        } else if (endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            class_2338 endSpawnPos = class_3218.field_25144;
            EndPortalEntity.generateClassicalEndPortal(world, class_243.method_24953((class_2382)endSpawnPos).method_1031(0.0, 1.0, 0.0), portalCenter);
        } else if (endPortalMode == IPGlobal.EndPortalMode.scaledView) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter, false);
        } else if (endPortalMode == IPGlobal.EndPortalMode.scaledViewRotating) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter, true);
        } else {
            LOGGER.error("End portal mode abnormal");
        }
        EndPortalEntity.doCreateEndPlatform(world);
        class_2881 dragonFight = world.method_29198();
        if (dragonFight == null) {
            return;
        }
        if (((IEEndDragonFight)dragonFight).ip_getNeedsStateScanning()) {
            ((IEEndDragonFight)dragonFight).ip_scanState();
        }
    }

    private static void doCreateEndPlatform(class_3218 world) {
        class_9829.method_61118((class_5425)world, (class_2338)class_2338.method_49638((class_2374)class_3218.field_25144.method_61082()).method_10074(), (boolean)true);
    }

    private static void generateClassicalEndPortal(class_3218 world, class_243 destination, class_243 portalCenter) {
        EndPortalEntity portal = new EndPortalEntity(ENTITY_TYPE, (class_1937)world);
        portal.method_5814(portalCenter.field_1352, portalCenter.field_1351, portalCenter.field_1350);
        portal.setDestination(destination);
        portal.setDestDim((class_5321<class_1937>)class_1937.field_25181);
        portal.setAxisW(new class_243(0.0, 0.0, 1.0));
        portal.setAxisH(new class_243(1.0, 0.0, 0.0));
        portal.setWidth(3.0);
        portal.setHeight(3.0);
        world.method_8649((class_1297)portal);
    }

    private static void generateScaledViewEndPortal(class_3218 world, class_243 frameCenter, boolean hasAnimation) {
        class_3218 endWorld = world.method_8503().method_3847(class_1937.field_25181);
        Validate.notNull((Object)endWorld, (String)"End dimension is not loaded", (Object[])new Object[0]);
        double sideLen = 3.0;
        double otherSideSideLen = 288.0;
        double height = 1.5;
        class_243 viewBoxSize = new class_243(sideLen, height, sideLen);
        double scale = otherSideSideLen / sideLen;
        class_238 thisSideBox = Helper.getBoxByBottomPosAndSize(frameCenter.method_1031(0.0, 0.2, 0.0), viewBoxSize);
        class_238 otherSideBox = Helper.getBoxByBottomPosAndSize(new class_243(0.0, 0.0, 0.0), viewBoxSize.method_1021(scale));
        class_243 portalCenter = thisSideBox.method_1005();
        EndPortalEntity portal = (EndPortalEntity)ENTITY_TYPE.method_5883((class_1937)world);
        assert (portal != null);
        portal.setOriginPos(portalCenter);
        portal.setDestDim((class_5321<class_1937>)endWorld.method_27983());
        portal.setDestination(otherSideBox.method_1005());
        portal.setAxisW(new class_243(1.0, 0.0, 0.0));
        portal.setAxisH(new class_243(0.0, 1.0, 0.0));
        portal.setWidth(sideLen);
        portal.setHeight(height);
        portal.setThickness(sideLen);
        portal.setPortalShape(BoxPortalShape.FACING_OUTWARDS);
        portal.setScaling(scale);
        portal.setTeleportChangesScale(false);
        portal.portalTag = PORTAL_TAG_VIEW_BOX;
        portal.setInteractable(false);
        portal.setCrossPortalCollisionEnabled(false);
        portal.setFuseView(true);
        if (hasAnimation) {
            class_243 rotationCenter = portalCenter;
            portal.addThisSideAnimationDriver(new RotationAnimation.Builder().setDegreesPerTick(0.5).setInitialOffset(class_243.field_1353).setRotationAxis(new class_243(0.0, 1.0, 0.0)).setStartGameTime(world.method_8510()).setEndGameTime(Long.MAX_VALUE).build());
            portal.addThisSideAnimationDriver(NormalAnimation.createOscillationAnimation(new class_243(0.0, 0.3, 0.0), 100, world.method_8510()));
        }
        McHelper.spawnServerEntity(portal);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.tickClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void tickClient() {
        if (this.isViewBoxPortal()) {
            class_243 cameraPosVec;
            double dist;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (this.getPortalShape() instanceof BoxPortalShape) {
                class_243 cameraPosVec2 = player.method_5836(1.0f);
                double dist2 = this.getDistanceToNearestPointInPortal(cameraPosVec2);
                if (dist2 < 1.0 && this.isInBoxPortalTeleportataionRange(cameraPosVec2)) {
                    double mul = 0.5;
                    player.method_18800(player.method_18798().field_1352 * mul, player.method_18798().field_1351 * mul, player.method_18798().field_1350 * mul);
                }
            } else if (this.getNormal().field_1351 > 0.5 && ((IEEntity)player).ip_getCollidingPortal() == this && (dist = this.getDistanceToNearestPointInPortal(cameraPosVec = player.method_5836(1.0f))) < 1.0) {
                double mul = dist / 2.0 + 0.1;
                player.method_18800(player.method_18798().field_1352 * mul, player.method_18798().field_1351 * mul, player.method_18798().field_1350 * mul);
            }
            this.setFuseView(true);
        }
    }

    @Override
    public void onEntityTeleportedOnServer(class_1297 entity) {
        super.onEntityTeleportedOnServer(entity);
        if (this.shouldAddSlowFalling(entity)) {
            int duration = 200;
            if (this.isViewBoxPortal()) {
                duration = 400;
            }
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6092(new class_1293(class_1294.field_5906, duration, 1));
        }
        MinecraftServer server = this.method_5682();
        assert (server != null);
        class_3218 endWorld = server.method_3847(class_1937.field_25181);
        if (endWorld != null) {
            EndPortalEntity.doCreateEndPlatform(endWorld);
        }
    }

    private boolean isViewBoxPortal() {
        return Objects.equals(this.portalTag, PORTAL_TAG_VIEW_BOX);
    }

    @Override
    public class_243 transformVelocityRelativeToPortal(class_243 originalVelocityRelativeToPortal, class_1297 entity, class_243 oldEntityPos) {
        if (this.isViewBoxPortal()) {
            class_243 offset = oldEntityPos.method_1020(this.getOriginPos());
            double horizontalDistanceSq = offset.field_1352 * offset.field_1352 + offset.field_1350 * offset.field_1350;
            double threshold = 1.0;
            if (horizontalDistanceSq > threshold * threshold) {
                return class_243.field_1353;
            }
        }
        return super.transformVelocityRelativeToPortal(originalVelocityRelativeToPortal, entity, oldEntityPos);
    }

    @Override
    public boolean canTeleportEntity(class_1297 entity) {
        if (entity instanceof class_1667) {
            return false;
        }
        if (this.getPortalShape() instanceof BoxPortalShape && !this.isInBoxPortalTeleportataionRange(entity.method_5836(1.0f))) {
            return false;
        }
        return super.canTeleportEntity(entity);
    }

    private boolean shouldAddSlowFalling(class_1297 entity) {
        if (entity instanceof class_1309) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                if (player.field_13974.method_14257() == class_1934.field_9220) {
                    return false;
                }
                if (player.method_6118(class_1304.field_6174).method_7909() == class_1802.field_8833) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLimitBoundingBox() {
        return false;
    }

    @Override
    public void onCollidingWithEntity(class_1297 entity) {
        if (!this.method_37908().method_8608() && entity instanceof class_3222 && IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            MinecraftServer server = this.method_5682();
            assert (server != null);
            class_3218 endWorld = server.method_3847(class_1937.field_25181);
            if (endWorld != null) {
                EndPortalEntity.doCreateEndPlatform(endWorld);
            }
        }
    }

    public boolean isInBoxPortalTeleportataionRange(class_243 pos) {
        class_243 offset = pos.method_1020(this.getOriginPos());
        double horizontalDistanceSq = offset.field_1352 * offset.field_1352 + offset.field_1350 * offset.field_1350;
        double threshold = 1.5;
        return horizontalDistanceSq <= threshold * threshold;
    }
}

